<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <title>Testu Kategorijas</title>
    <link rel="stylesheet" href="../style.css">
    <style>
        h2 {
            text-align: center;
            margin-top: 20px;
        }
        ul {
            list-style-type: none;
            padding: 0;
            margin: 0;
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
        }
        li {
            margin: 10px;
        }
        li a {
            text-decoration: none;
            background-color: #555;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
            display: inline-block;
        }
        li a:hover {
            background-color: #777;
        }
        form {
            text-align: center;
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
            gap: 10px;
        }
        label {
            font-size: 18px;
            margin-right: 10px;
        }
        select, button, input[type="text"] {
            padding: 10px;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
            margin-right: 10px;
        }
        button {
            background-color: #555;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #777;
        }
        h1 {
            text-align: center;
            font-size: 24px;
        }
        .test-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
        }
        .test-item {
            background-color: #fff;
            border: 1px solid #ccc;
            padding: 20px;
            width: 200px;
            height: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: transform 0.3s ease;
            cursor: pointer;
            text-align: center;
        }
        .test-item:hover {
            transform: scale(1.05);
        }
        .test-name {
            font-weight: bold;
            color: #333;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <!-- Navigācijas josla -->
    <div id="navbar">
        <!-- LOGO poga, kurai ir pievienota onclick funkcija -->
        <div id="logo" onclick="redirectToHomePage()">LOGO</div>
        <!-- Pārējā navigācija -->
        <button onclick="location.href='../php/list_tests.php'">Visi testi</button>
        <button id="createTestBtn" onclick="openTestCreationView()">Testu veidošana</button>
        <div id="profileBtn" class="dropdown" onclick="toggleDropdown()">Profils
            <div class="dropdown-content" id="dropdownContent">
                <a href="../html/iestatijumi.html">Iestatījumi</a>
                <a href="../html/vesture.html">Vēsture</a>
                <a href="../html/rezultati.html">Rezultāti</a>
                <a href="../html/testu_parvaldisana.html">Testu pārvaldīšana</a>
                <a href="../html/sakumlapa1.html" onclick="logout()">Iziet</a>
                <!-- Teacher Dashboard Button -->
                <a href="../html/teacher_dashboard.html" id="teacherDashboardBtn" style="display: none;">Skolotāju panelis</a>
            </div>
        </div>
    </div>

    <h1>Testu Saraksts</h1>

    <form action="" method="GET">
        <label for="category">Priekšmets</label>
        <select name="category" id="category">
            <option value="">Visas kategorijas</option>
            <?php
            // Datu bāzes savienojums
            $servername = "localhost";
            $username = "root";
            $password = "";
            $dbname = "quiz_db";

            $conn = new mysqli($servername, $username, $password, $dbname);
            if ($conn->connect_error) {
                die("Savienojums neizdevās: " . $conn->connect_error);
            }

            // Iegūst unikālās kategorijas no datu bāzes
            $sql = "SELECT DISTINCT category FROM tests";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row["category"] . "'>" . $row["category"] . "</option>";
                }
            }
            $conn->close();
            ?>
        </select>
        <label for="language">Valoda</label>
        <select name="language" id="language">
            <option value="">Visas valodas</option>
            <?php
            // Datu bāzes savienojums
            $conn = new mysqli($servername, $username, $password, $dbname);
            if ($conn->connect_error) {
                die("Savienojums neizdevās: " . $conn->connect_error);
            }

            // Iegūst unikālās valodas no datu bāzes
            $sql = "SELECT DISTINCT language FROM tests";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<option value='" . $row["language"] . "'>" . $row["language"] . "</option>";
                }
            }
            $conn->close();
            ?>
        </select>
        <label for="search">Meklēt:</label>
        <input type="text" name="search" id="search" placeholder="Meklēt testus">
        <button type="submit">Pievienot filtrus</button>
    </form>

    <h2>Pieejamie testi:</h2>
    <div class="test-container">
        <?php
        // Datu bāzes savienojums
        $conn = new mysqli($servername, $username, $password, $dbname);
        if ($conn->connect_error) {
            die("Savienojums neizdevās: " . $conn->connect_error);
        }

        $search_query = "";
        if(isset($_GET['search']) && !empty($_GET['search'])) {
            $search_query = " AND name LIKE '%" . $conn->real_escape_string($_GET['search']) . "%'";
        }

        $category_query = "";
        if(isset($_GET['category']) && !empty($_GET['category'])) {
            $category_query = " AND category = '" . $conn->real_escape_string($_GET['category']) . "'";
        }

        $language_query = "";
        if(isset($_GET['language']) && !empty($_GET['language'])) {
            $language_query = " AND language = '" . $conn->real_escape_string($_GET['language']) . "'";
        }

        // Iegūst testus ar izvēlētajiem filtriem
        $sql = "SELECT id, name FROM tests WHERE 1=1" . $search_query . $category_query . $language_query;

        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                // Katru testa nosaukumu padara klikšķamu, lai sāktu testu
                echo "<div class='test-item' onclick=\"location.href='take_test.php?test_id=" . $row["id"] . "'\"><div class='test-name'>" . $row["name"] . "</div></div>";
            }
        } else {
            echo "<div class='test-item'>Testi nav atrasti.</div>";
        }
        $conn->close();
        ?>
    </div>

    <script src="../js/redirects.js"></script> <!-- Iekļauj redirects.js failu -->
    
    <script>
        // JavaScript funkcija, kas novirza uz sakumlapa.html lapu
        function redirectToHomePage() {
            window.location.href = '../html/sakumlapa.html';
        }
        // Function to open test creation view
        function openTestCreationView() {
            // Redirect to "Test Creation" page
            window.location.href = '../html/testu_veidosanai.html';
        }
    </script>
    
</body>
</html>
